#include <iostream>
#include <vector>
#include <bitset>
#include <map>

using namespace std;

const long long MAX_BOUND = 20200;// TODO

int main(){
	ios::sync_with_stdio(0);

	long long n, k, x;

	cin >> n >> k;
	// long long bound = min(min(2 * k + 3, MAX_BOUND), 2*n);
	bitset<MAX_BOUND> lower;
	bitset<MAX_BOUND> upper;

	const long long lower_bound =  min(n, MAX_BOUND);
	const long long upper_bound =  n - min(n, MAX_BOUND);

	for(int i = 1; i <= lower_bound; i++){
		lower[i] = 1;
	}
	for(int i = upper_bound; i <= n; i++){
		upper[n - i] = 1;
	}

	// cout << lower_bound << " " << upper_bound << endl;
	for(int i = 0; i < k; i++){
		cin >> x;
		if(x <= lower_bound) lower[x] = 0;
		if(x >= upper_bound) upper[n - x] = 0;
	}
	// convolve lower set
	bitset<MAX_BOUND> lower_cnt;
	for(int i = 0; i < lower.size(); i++){
		if(lower[i] == 1){
			lower_cnt = lower_cnt | (lower << i);
		}
	}

	// convolve upper set
	bitset<MAX_BOUND> upper_cnt;
	for(int i = 0; i < upper.size(); i++){
		if(upper[i] == 1){
			upper_cnt = upper_cnt | (upper << i);
		}
	}


	long long deleted = 0;
	for(long long i = 1; i <= min(n, MAX_BOUND-1); i++){
		if(lower_cnt[i] == 0){
			deleted++;
		}
	}

	for(long long i = max(n + 1, 2*n - MAX_BOUND+1); i <= 2*n; i++){
		if(upper_cnt[2*n - i] == 0){
			deleted++;
		}
	}
	cout << 2*n - deleted << endl;
}
